function value=get(obj,property)
% GET retourne la valeur de la proprit demande de l'objet marche.
%   value=GET(obj,property)
%       >> obj      = objet informatique marche;
%       >> property = proprit de la marche;
%       << value    = valeur de la proprit.
%
%   Olivier Pujol : septembre 2013
%
switch property 
    case 'Nom'
        value=obj.name;
    case 'Position'
        value=obj.x;
    case 'EnergiePotentielleEntree'
        value=obj.Epe;
    case 'EnergiePotentielleSortie'
        value=obj.Eps;
    case 'VecteurOndeEntree'
        value=obj.ke;
    case 'VecteurOndeSortie'
        value=obj.ks;
    otherwise
        error([property,' n''est pas une proprit de la marche !']);
end
%
return;